/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.utility.POSPrinter;

import jpos.JposException;

public class MapModeConversion {
    private int m_mapMode = 1;
    private double m_dotDimensionHeight = 0.125;
    private double m_dotDimensionWidth = 0.125;

    public int getMapMode() {
        return this.m_mapMode;
    }

    public double getDotDimensionHeight() {
        return this.m_dotDimensionHeight;
    }

    public void setDotDimensionHeight(double d) {
        this.m_dotDimensionHeight = d;
    }

    public double getDotDimensionWidth() {
        return this.m_dotDimensionWidth;
    }

    public void setDotDimensionWidth(double d) {
        this.m_dotDimensionWidth = d;
    }

    public void setMapMode(int n) throws JposException {
        if (1 != n && 3 != n && 4 != n && 2 != n) {
            throw new JposException(106, "This request is illegal because the mapMode parameter is unsupported.");
        }
        this.m_mapMode = n;
    }

    public int mapModeToDot(int n, double d) {
        if (this.m_mapMode == 2) {
            return (int)((double)n * 0.017638888888888888 / d);
        }
        if (this.m_mapMode == 3) {
            return (int)((double)n * 0.0254 / d);
        }
        if (this.m_mapMode == 4) {
            return (int)((double)n / 100.0 / d);
        }
        return n;
    }

    public int dotToMapMode(int n, double d) {
        if (this.m_mapMode == 2) {
            return (int)((double)n * d * 56.69291338582678);
        }
        if (this.m_mapMode == 3) {
            return (int)((double)n * d * 39.37007874015748);
        }
        if (this.m_mapMode == 4) {
            return (int)((double)n * d * 100.0);
        }
        return n;
    }

    public int mapModeToDotHeight(int n) {
        if (this.m_mapMode == 2) {
            return (int)((double)n * 0.017638888888888888 / this.m_dotDimensionHeight);
        }
        if (this.m_mapMode == 3) {
            return (int)((double)n * 0.0254 / this.m_dotDimensionHeight);
        }
        if (this.m_mapMode == 4) {
            return (int)((double)n / 100.0 / this.m_dotDimensionHeight);
        }
        return n;
    }

    public int mapModeToDotWidth(int n) {
        if (this.m_mapMode == 2) {
            return (int)((double)n * 0.017638888888888888 / this.m_dotDimensionWidth);
        }
        if (this.m_mapMode == 3) {
            return (int)((double)n * 0.0254 / this.m_dotDimensionWidth);
        }
        if (this.m_mapMode == 4) {
            return (int)((double)n / 100.0 / this.m_dotDimensionWidth);
        }
        return n;
    }
}

